/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.breadcrumb;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLObject;

public class Breadcrumb {
    @Nonnull
    private final OWLObject object;
    @Nullable
    private final Object parentRelationship;

    public Breadcrumb(@Nonnull OWLObject object, @Nullable Object parentRelationship) {
        this.object = (OWLObject)Preconditions.checkNotNull((Object)object);
        this.parentRelationship = parentRelationship;
    }

    @Nonnull
    public OWLObject getObject() {
        return this.object;
    }

    @Nonnull
    public Optional<?> getParentRelationship() {
        return Optional.ofNullable(this.parentRelationship);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.object, this.parentRelationship});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Breadcrumb)) {
            return false;
        }
        Breadcrumb other = (Breadcrumb)obj;
        return this.object.equals((Object)other.object) && Objects.equal((Object)this.parentRelationship, (Object)other.parentRelationship);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Breadcrumb").addValue((Object)this.object).toString();
    }
}

