/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UEmpty;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.nwdiag.core.NServer;
import net.sourceforge.plantuml.nwdiag.core.NStackable;
import net.sourceforge.plantuml.nwdiag.core.Network;
import net.sourceforge.plantuml.nwdiag.core.NwGroup;
import net.sourceforge.plantuml.nwdiag.next.GridTextBlockDecorated;
import net.sourceforge.plantuml.nwdiag.next.NBar;
import net.sourceforge.plantuml.nwdiag.next.NPlayField;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class NwDiagram
extends UmlDiagram {
    private boolean initDone;
    private final Map<String, NServer> servers = new LinkedHashMap<String, NServer>();
    private final List<Network> networks = new ArrayList<Network>();
    private final List<NwGroup> groups = new ArrayList<NwGroup>();
    private final List<NStackable> stack = new ArrayList<NStackable>();
    private final NPlayField playField = new NPlayField();
    private final double margin = 5.0;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Nwdiag)");
    }

    public NwDiagram(UmlSource source) {
        super(source, UmlDiagramType.NWDIAG, null);
    }

    public void init() {
        this.initDone = true;
    }

    private Network currentNetwork() {
        for (int i = 0; i < this.stack.size(); ++i) {
            if (!(this.stack.get(i) instanceof Network)) continue;
            return (Network)this.stack.get(i);
        }
        return null;
    }

    private NwGroup currentGroup() {
        if (this.stack.size() > 0 && this.stack.get(0) instanceof NwGroup) {
            return (NwGroup)this.stack.get(0);
        }
        return null;
    }

    @Override
    public void makeDiagramReady() {
        super.makeDiagramReady();
        for (NServer server : this.servers.values()) {
            server.connectMeIfAlone(this.networks.get(0));
            this.playField.addInPlayfield(server.getBar());
        }
    }

    public CommandExecutionResult openGroup(String name) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        for (NStackable element : this.stack) {
            if (!(element instanceof NwGroup)) continue;
            return CommandExecutionResult.error("Cannot nest group");
        }
        NwGroup newGroup = new NwGroup(name);
        this.stack.add(0, newGroup);
        this.groups.add(newGroup);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult openNetwork(String name) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        if (this.currentGroup() != null) {
            return CommandExecutionResult.error("Cannot open network in a group");
        }
        for (NStackable element : this.stack) {
            if (!(element instanceof Network)) continue;
            return CommandExecutionResult.error("Cannot nest network");
        }
        Network network = this.createNetwork(name);
        this.stack.add(0, network);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult closeSomething() {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        if (this.stack.size() > 0) {
            this.stack.remove(0);
        }
        return CommandExecutionResult.ok();
    }

    private Network createNetwork(String name) {
        Network network = new Network(this.playField.getLast(), this.playField.createNewStage(), name);
        this.networks.add(network);
        return network;
    }

    public CommandExecutionResult link(String name1, String name2) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        NServer server1 = this.servers.get(name1);
        if (server1 == null) {
            if (this.networks.size() == 0) {
                return this.veryFirstLink(name1, name2);
            }
            return CommandExecutionResult.error("what about " + name1);
        }
        NServer server2 = this.servers.get(name2);
        Network network = this.createNetwork("");
        network.goInvisible();
        if (server2 == null) {
            server2 = new NServer(name2, server1.getBar(), this.getSkinParam());
            this.servers.put(name2, server2);
            server1.connectTo(network, "");
            server2.connectTo(network, "");
        } else {
            server1.blankSomeAddress();
            server1.connectTo(network, server1.someAddress());
            server2.connectTo(network, server2.someAddress());
        }
        this.playField.addInPlayfield(server2.getBar());
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult veryFirstLink(String name1, String name2) {
        Network network = this.createNetwork(name1);
        NServer server2 = NServer.create(name2, this.getSkinParam());
        this.servers.put(name2, server2);
        server2.connectTo(network, "");
        this.playField.addInPlayfield(server2.getBar());
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult linkOld(String name1, String name2) {
        NServer server2;
        if (!this.initDone) {
            return this.errorNoInit();
        }
        String existingAddress = "";
        Network created = null;
        if (this.currentNetwork() == null && this.networks.size() == 0) {
            created = this.createNetwork(name1);
            server2 = NServer.create(name2, this.getSkinParam());
        } else {
            NServer server1 = this.servers.get(name1);
            NServer previous2 = this.servers.get(name2);
            if (previous2 != null) {
                existingAddress = previous2.someAddress();
            }
            created = this.createNetwork("");
            created.goInvisible();
            if (server1 != null) {
                Network someNetwork = server1.someNetwork();
                if (someNetwork != null && !someNetwork.isVisible() && someNetwork.getUp() == null) {
                    String tmp = server1.someAddress();
                    server1.blankSomeAddress();
                    server1.connectTo(created, tmp);
                } else {
                    server1.connectTo(created, "");
                }
            }
            server2 = new NServer(name2, server1.getBar(), this.getSkinParam());
        }
        this.servers.put(name2, server2);
        if (created == null) {
            server2.connectTo(this.currentNetwork(), existingAddress);
        } else {
            server2.connectTo(created, existingAddress);
        }
        this.playField.addInPlayfield(server2.getBar());
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult addElement(String name, String definition) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        Map<String, String> props = this.toSet(definition);
        NServer server = this.servers.get(name);
        if (server == null) {
            server = NServer.create(name, this.getSkinParam());
            this.servers.put(name, server);
        }
        if (this.currentGroup() != null) {
            if (this.alreadyInSomeGroup(name)) {
                return CommandExecutionResult.error("Element already in another group.");
            }
            this.currentGroup().addName(name);
            if (this.currentNetwork() == null) {
                server.updateProperties(props);
                return CommandExecutionResult.ok();
            }
        }
        if (this.networks.size() == 0) {
            Network network = this.createNetwork("");
            network.goInvisible();
            server.connectTo(network, props.get("address"));
            this.playField.addInPlayfield(server.getBar());
            server.doNotPrintFirstLink();
        } else if (this.currentNetwork() != null) {
            server.connectTo(this.currentNetwork(), props.get("address"));
            this.playField.addInPlayfield(server.getBar());
        } else {
            server.learnThisAddress(props.get("address"));
        }
        server.updateProperties(props);
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult addElementOld(String name, String definition) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        if (this.currentGroup() != null) {
            if (this.alreadyInSomeGroup(name)) {
                return CommandExecutionResult.error("Element already in another group.");
            }
            this.currentGroup().addName(name);
        }
        NServer server = null;
        Network created = null;
        if (this.currentNetwork() == null) {
            if (this.currentGroup() != null) {
                return CommandExecutionResult.ok();
            }
            assert (this.currentGroup() == null);
            created = this.createNetwork("");
            created.goInvisible();
            server = NServer.create(name, this.getSkinParam());
            this.servers.put(name, server);
            server.doNotPrintFirstLink();
        } else {
            server = this.servers.get(name);
            if (server == null) {
                server = NServer.create(name, this.getSkinParam());
                this.servers.put(name, server);
            }
        }
        Map<String, String> props = this.toSet(definition);
        if (created == null) {
            server.connectTo(this.currentNetwork(), props.get("address"));
        } else {
            server.connectTo(created, props.get("address"));
        }
        server.updateProperties(props);
        this.playField.addInPlayfield(server.getBar());
        return CommandExecutionResult.ok();
    }

    private boolean alreadyInSomeGroup(String name) {
        for (NwGroup g : this.groups) {
            if (!g.names().contains(name)) continue;
            return true;
        }
        return false;
    }

    private CommandExecutionResult errorNoInit() {
        return CommandExecutionResult.error("Maybe you forget 'nwdiag {' in your diagram ?");
    }

    private Map<String, String> toSet(String definition) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (definition == null) {
            return result;
        }
        Pattern p = Pattern.compile("\\s*(\\w+)\\s*=\\s*(\"([^\"]*)\"|[^\\s,]+)");
        Matcher m = p.matcher(definition);
        while (m.find()) {
            String name = m.group(1);
            String value = m.group(3) == null ? m.group(2) : m.group(3);
            result.put(name, value);
        }
        return result;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    @Override
    protected TextBlock getTextBlock() {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                NwDiagram.this.drawMe(ug);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return NwDiagram.this.getTotalDimension(stringBounder);
            }
        };
    }

    private StyleSignatureBasic getStyleDefinitionNetwork(SName sname) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.nwdiagDiagram, sname);
    }

    private TextBlock toTextBlockForNetworkName(String name, String s) {
        if (s != null) {
            name = name + "\\n" + s;
        }
        StyleBuilder styleBuilder = this.getSkinParam().getCurrentStyleBuilder();
        Style style = this.getStyleDefinitionNetwork(SName.network).getMergedStyle(styleBuilder);
        FontConfiguration fontConfiguration = style.getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        return Display.getWithNewlines(name).create(fontConfiguration, HorizontalAlignment.RIGHT, new SpriteContainerEmpty());
    }

    private XDimension2D getTotalDimension(StringBounder stringBounder) {
        return TextBlockUtils.getMinMax(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                NwDiagram.this.drawMe(ug);
            }
        }, stringBounder, true).getDimension();
    }

    private void drawMe(UGraphic ug) {
        ug = ug.apply(new UTranslate(5.0, 5.0));
        StringBounder stringBounder = ug.getStringBounder();
        double deltaX = 0.0;
        double deltaY = 0.0;
        GridTextBlockDecorated grid = this.buildGrid(stringBounder);
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            String address = current.getOwnAdress();
            TextBlock desc = this.toTextBlockForNetworkName(current.getDisplayName(), address);
            XDimension2D dim = desc.calculateDimension(stringBounder);
            if (i == 0) {
                deltaY = (dim.getHeight() - 5.0) / 2.0;
            }
            deltaX = Math.max(deltaX, dim.getWidth());
        }
        double y = 0.0;
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            String address = current.getOwnAdress();
            TextBlock desc = this.toTextBlockForNetworkName(current.getDisplayName(), address);
            XDimension2D dim = desc.calculateDimension(stringBounder);
            desc.drawU(ug.apply(new UTranslate(deltaX - dim.getWidth(), y)));
            y += grid.lineHeight(stringBounder, i);
        }
        grid.drawU(ug.apply(new UTranslate(deltaX += 5.0, deltaY)));
        XDimension2D dimGrid = grid.calculateDimension(stringBounder);
        ug.apply(new UTranslate(dimGrid.getWidth() + deltaX + 5.0, dimGrid.getHeight() + deltaY + 5.0)).draw(new UEmpty(1.0, 1.0));
    }

    private Map<Network, String> getLinks(NServer element) {
        LinkedHashMap<Network, String> result = new LinkedHashMap<Network, String>();
        for (Network network : this.networks) {
            String s = element.getAdress(network);
            if (s == null) continue;
            result.put(network, s);
        }
        return result;
    }

    private GridTextBlockDecorated buildGrid(StringBounder stringBounder) {
        this.playField.fixGroups(this.groups, this.servers.values());
        GridTextBlockDecorated grid = new GridTextBlockDecorated(this.networks.size(), this.servers.size(), this.groups, this.networks, this.getSkinParam());
        Map<NBar, Integer> layout = this.playField.doLayout();
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            for (Map.Entry<String, NServer> ent : this.servers.entrySet()) {
                NServer server = ent.getValue();
                if (server.getMainNetworkNext() != current) continue;
                Map<Network, String> conns = this.getLinks(server);
                Integer col = layout.get(server.getBar());
                if (col == null) continue;
                double topMargin = 15.0;
                NwGroup group = this.getGroupOf(server);
                if (group != null) {
                    topMargin += group.getTopHeaderHeight(stringBounder, this.getSkinParam());
                }
                grid.add(i, col, server.getDraw(topMargin, conns, this.networks, this.getSkinParam()));
            }
        }
        return grid;
    }

    private NwGroup getGroupOf(NServer server) {
        for (NwGroup group : this.groups) {
            if (!group.contains(server)) continue;
            return group;
        }
        return null;
    }

    public CommandExecutionResult setProperty(String property, String value) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        if ("address".equalsIgnoreCase(property) && this.currentNetwork() != null) {
            this.currentNetwork().setOwnAdress(value);
        }
        if ("width".equalsIgnoreCase(property) && this.currentNetwork() != null) {
            this.currentNetwork().setFullWidth("full".equalsIgnoreCase(value));
        }
        if ("color".equalsIgnoreCase(property)) {
            HColor color;
            HColor hColor = color = value == null ? null : this.getSkinParam().getIHtmlColorSet().getColorOrWhite(value);
            if (this.currentGroup() != null) {
                this.currentGroup().setColor(color);
            } else if (this.currentNetwork() != null) {
                this.currentNetwork().setColor(color);
            }
        }
        if ("description".equalsIgnoreCase(property)) {
            if (this.currentGroup() == null) {
                this.currentNetwork().setDescription(value);
            } else {
                this.currentGroup().setDescription(value);
            }
        }
        return CommandExecutionResult.ok();
    }

    @Override
    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return ClockwiseTopRightBottomLeft.none();
    }
}

