/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.controlpanel.DocumentAdapter;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.StreamUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class JVMPanel
extends NamedBorderPanel {
    private final DeploymentConfiguration config;
    private File lastPath = new File("/usr/lib/jvm/java/jre/");
    JTextField testFieldArgumentsExec;

    JVMPanel(DeploymentConfiguration config) {
        super(Translator.R("CPHeadJVMSettings"), new GridBagLayout());
        this.config = config;
        this.addComponents();
    }

    void resetTestFieldArgumentsExec() {
        this.testFieldArgumentsExec.setText("");
    }

    private void addComponents() {
        JLabel description = new JLabel("<html>" + Translator.R("CPJVMPluginArguments") + "<hr /></html>");
        JTextField testFieldArguments = new JTextField(25);
        testFieldArguments.getDocument().addDocumentListener(new DocumentAdapter(this.config, "deployment.plugin.jvm.arguments"));
        testFieldArguments.setText(this.config.getProperty("deployment.plugin.jvm.arguments"));
        JLabel descriptionExec = new JLabel("<html>" + Translator.R("CPJVMitwExec") + "<hr /></html>");
        this.testFieldArgumentsExec = new JTextField(100);
        final JLabel validationResult = new JLabel(this.resetValidationResult(this.testFieldArgumentsExec.getText(), "", "CPJVMnone"));
        validationResult.setToolTipText("");
        final JCheckBox allowTypoTimeValidation = new JCheckBox(Translator.R("CPJVMPluginAllowTTValidation"), true);
        allowTypoTimeValidation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                validationResult.setText(JVMPanel.this.resetValidationResult(JVMPanel.this.testFieldArgumentsExec.getText(), "", "CPJVMnone"));
                validationResult.setToolTipText("");
            }
        });
        this.testFieldArgumentsExec.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (allowTypoTimeValidation.isSelected()) {
                    JvmValidationResult s = JVMPanel.validateJvm(JVMPanel.this.testFieldArgumentsExec.getText());
                    validationResult.setText(JVMPanel.this.resetValidationResult(JVMPanel.this.testFieldArgumentsExec.getText(), s.formattedText, "CPJVMvalidated"));
                    validationResult.setToolTipText(s.stds);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (allowTypoTimeValidation.isSelected()) {
                    JvmValidationResult s = JVMPanel.validateJvm(JVMPanel.this.testFieldArgumentsExec.getText());
                    validationResult.setText(JVMPanel.this.resetValidationResult(JVMPanel.this.testFieldArgumentsExec.getText(), s.formattedText, "CPJVMvalidated"));
                    validationResult.setToolTipText(s.stds);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (allowTypoTimeValidation.isSelected()) {
                    JvmValidationResult s = JVMPanel.validateJvm(JVMPanel.this.testFieldArgumentsExec.getText());
                    validationResult.setText(JVMPanel.this.resetValidationResult(JVMPanel.this.testFieldArgumentsExec.getText(), s.formattedText, "CPJVMvalidated"));
                    validationResult.setToolTipText(s.stds);
                }
            }
        });
        this.testFieldArgumentsExec.getDocument().addDocumentListener(new DocumentAdapter(this.config, "deployment.jre.dir"));
        this.testFieldArgumentsExec.setText(this.config.getProperty("deployment.jre.dir"));
        JButton selectJvm = new JButton(Translator.R("CPJVMPluginSelectExec"));
        selectJvm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfch = JVMPanel.this.lastPath != null && JVMPanel.this.lastPath.exists() ? new JFileChooser(JVMPanel.this.lastPath) : new JFileChooser();
                jfch.setFileSelectionMode(1);
                int i = jfch.showOpenDialog(JVMPanel.this);
                if (i == 0 && jfch.getSelectedFile() != null) {
                    JVMPanel.this.lastPath = jfch.getSelectedFile().getParentFile();
                    String nws = jfch.getSelectedFile().getAbsolutePath();
                    String olds = JVMPanel.this.testFieldArgumentsExec.getText();
                    if (!nws.equals(olds)) {
                        validationResult.setText(JVMPanel.this.resetValidationResult(JVMPanel.this.testFieldArgumentsExec.getText(), "", "CPJVMnone"));
                        validationResult.setToolTipText("");
                    }
                    JVMPanel.this.testFieldArgumentsExec.setText(nws);
                }
            }
        });
        JButton validateJvm = new JButton(Translator.R("CPJVMitwExecValidation"));
        validateJvm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JvmValidationResult s = JVMPanel.validateJvm(JVMPanel.this.testFieldArgumentsExec.getText());
                validationResult.setText(JVMPanel.this.resetValidationResult(JVMPanel.this.testFieldArgumentsExec.getText(), s.formattedText, "CPJVMvalidated"));
                validationResult.setToolTipText(s.stds);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 4;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 4, 4);
        this.add((Component)description, c);
        ++c.gridy;
        this.add((Component)testFieldArguments, c);
        ++c.gridy;
        this.add((Component)descriptionExec, c);
        ++c.gridy;
        this.add((Component)this.testFieldArgumentsExec, c);
        ++c.gridy;
        GridBagConstraints cb1 = (GridBagConstraints)c.clone();
        cb1.fill = 0;
        cb1.gridwidth = 1;
        this.add((Component)selectJvm, cb1);
        GridBagConstraints cb3 = (GridBagConstraints)c.clone();
        cb3.fill = 0;
        cb3.gridx = 2;
        cb3.gridwidth = 1;
        this.add((Component)allowTypoTimeValidation, cb3);
        GridBagConstraints cb2 = (GridBagConstraints)c.clone();
        cb2.fill = 0;
        cb2.gridx = 3;
        cb2.gridwidth = 1;
        this.add((Component)validateJvm, cb2);
        ++c.gridy;
        this.add((Component)validationResult, c);
        Component filler = Box.createRigidArea(new Dimension(1, 1));
        ++c.gridy;
        c.weighty += 1.0;
        this.add(filler, c);
    }

    public static JvmValidationResult validateJvm(String cmd) {
        if (cmd == null || cmd.trim().equals("")) {
            return new JvmValidationResult("<span color=\"orange\">" + Translator.R("CPJVMvalueNotSet") + "</span>", JvmValidationResult.STATE.EMPTY, "");
        }
        String validationResult = "";
        File jreDirFile = new File(cmd);
        JvmValidationResult.STATE latestOne = JvmValidationResult.STATE.EMPTY;
        if (jreDirFile.isDirectory()) {
            validationResult = validationResult + "<span color=\"green\">" + Translator.R("CPJVMisDir") + "</span><br />";
        } else {
            validationResult = validationResult + "<span color=\"red\">" + Translator.R("CPJVMnotDir") + "</span><br />";
            latestOne = JvmValidationResult.STATE.NOT_DIR;
        }
        File javaFile = new File(cmd + File.separator + "bin" + File.separator + "java" + (JNLPRuntime.isWindows() ? ".exe" : ""));
        if (javaFile.isFile()) {
            validationResult = validationResult + "<span color=\"green\">" + Translator.R("CPJVMjava") + "</span><br />";
        } else {
            validationResult = validationResult + "<span color=\"red\">" + Translator.R("CPJVMnoJava") + "</span><br />";
            if (latestOne != JvmValidationResult.STATE.NOT_DIR) {
                latestOne = JvmValidationResult.STATE.NOT_VALID_JDK;
            }
        }
        ProcessBuilder sb = new ProcessBuilder(javaFile.getAbsolutePath(), "-version");
        Process p = null;
        String processErrorStream = "";
        String processStdOutStream = "";
        Integer r = null;
        try {
            p = sb.start();
            StreamUtils.waitForSafely(p);
            processErrorStream = StreamUtils.readStreamAsString(p.getErrorStream());
            processStdOutStream = StreamUtils.readStreamAsString(p.getInputStream());
            r = p.exitValue();
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, processErrorStream);
            OutputController.getLogger().log(processStdOutStream);
            processErrorStream = processErrorStream.toLowerCase();
            processStdOutStream = processStdOutStream.toLowerCase();
        }
        catch (Exception ex) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
        }
        if (r == null) {
            validationResult = validationResult + "<span color=\"red\">" + Translator.R("CPJVMnotLaunched") + "</span>";
            if (latestOne != JvmValidationResult.STATE.NOT_DIR) {
                latestOne = JvmValidationResult.STATE.NOT_VALID_JDK;
            }
            return new JvmValidationResult(validationResult, latestOne, "");
        }
        String reportableOutputs = processErrorStream + "\n" + processStdOutStream;
        if (r != 0) {
            validationResult = validationResult + "<span color=\"red\">" + Translator.R("CPJVMnoSuccess") + "</span>";
            if (latestOne != JvmValidationResult.STATE.NOT_DIR) {
                latestOne = JvmValidationResult.STATE.NOT_VALID_JDK;
            }
            return new JvmValidationResult(validationResult, latestOne, reportableOutputs);
        }
        boolean findRT = false;
        boolean jdk9up = false;
        for (int i = 9; i <= 99; ++i) {
            if (!processErrorStream.contains("\"" + i) && !processStdOutStream.contains("\"" + i)) continue;
            jdk9up = true;
        }
        if (jdk9up) {
            validationResult = validationResult + "<span color=\"green\">" + Translator.R("CPJVMjdk9") + "</span><br />";
            findRT = false;
        } else if (processErrorStream.contains("1.8.0") || processStdOutStream.contains("1.8.0")) {
            validationResult = validationResult + "<span color=\"#00EE00\">" + Translator.R("CPJVMjdk8") + "</span><br />";
            findRT = true;
        } else if (processErrorStream.contains("1.7.0") || processStdOutStream.contains("1.7.0")) {
            validationResult = validationResult + "<span color=\"#EE0000\">" + Translator.R("CPJVMjdk7") + "</span><br />";
            if (latestOne != JvmValidationResult.STATE.NOT_DIR) {
                latestOne = JvmValidationResult.STATE.NOT_VALID_JDK;
                findRT = true;
            }
        } else if (processErrorStream.contains("1.6.0") || processStdOutStream.contains("1.6.0")) {
            validationResult = validationResult + "<span color=\"#EE0000\">" + Translator.R("CPJVMjdk6") + "</span><br />";
            if (latestOne != JvmValidationResult.STATE.NOT_DIR) {
                latestOne = JvmValidationResult.STATE.NOT_VALID_JDK;
                findRT = true;
            }
        } else {
            validationResult = validationResult + "<span color=\"yellow\">" + Translator.R("CPJVMjdk") + "</span><br />";
            if (latestOne != JvmValidationResult.STATE.NOT_DIR) {
                latestOne = JvmValidationResult.STATE.NOT_VALID_JDK;
                findRT = false;
            }
        }
        if (findRT) {
            File rtFile = new File(cmd + File.separator + "lib" + File.separator + "rt.jar");
            if (rtFile.isFile()) {
                validationResult = validationResult + "<span color=\"green\">" + Translator.R("CPJVMrtJar") + "</span><br />";
            } else {
                validationResult = validationResult + "<span color=\"red\">" + Translator.R("CPJVMnoRtJar") + "</span><br />";
                if (latestOne != JvmValidationResult.STATE.NOT_DIR) {
                    latestOne = JvmValidationResult.STATE.NOT_VALID_JDK;
                }
            }
        }
        if (processErrorStream.contains("openjdk") || processStdOutStream.contains("openjdk")) {
            validationResult = validationResult + "<span color=\"#00EE00\">" + Translator.R("CPJVMopenJdkFound") + "</span>";
            return new JvmValidationResult(validationResult, JvmValidationResult.STATE.VALID_JDK, reportableOutputs);
        }
        if (processErrorStream.contains("ibm") || processStdOutStream.contains("ibm")) {
            validationResult = validationResult + "<span color=\"green\">" + Translator.R("CPJVMibmFound") + "</span>";
            if (latestOne != JvmValidationResult.STATE.NOT_DIR) {
                latestOne = JvmValidationResult.STATE.NOT_VALID_JDK;
            }
            return new JvmValidationResult(validationResult, latestOne, reportableOutputs);
        }
        if (processErrorStream.contains("gij") || processStdOutStream.contains("gij")) {
            validationResult = validationResult + "<span color=\"orange\">" + Translator.R("CPJVMgijFound") + "</span>";
            if (latestOne != JvmValidationResult.STATE.NOT_DIR) {
                latestOne = JvmValidationResult.STATE.NOT_VALID_JDK;
            }
            return new JvmValidationResult(validationResult, latestOne, reportableOutputs);
        }
        if (processErrorStream.contains("oracle") || processStdOutStream.contains("oracle") || processErrorStream.contains("java(tm)") || processStdOutStream.contains("java(tm)")) {
            validationResult = validationResult + "<span color=\"green\">" + Translator.R("CPJVMoracleFound") + "</span>";
            if (latestOne != JvmValidationResult.STATE.NOT_DIR) {
                latestOne = JvmValidationResult.STATE.NOT_VALID_JDK;
            }
            return new JvmValidationResult(validationResult, latestOne, reportableOutputs);
        }
        validationResult = validationResult + "<span color=\"orange\">" + Translator.R("CPJVMstrangeProcess") + "</span>";
        return new JvmValidationResult(validationResult, JvmValidationResult.STATE.NOT_VALID_JDK, reportableOutputs);
    }

    private String resetValidationResult(String value, String result, String headerKey) {
        return "<html>" + Translator.R(headerKey) + ": <br />" + value + " <br />" + result + "<hr /></html>";
    }

    public static class JvmValidationResult {
        public final String formattedText;
        public final STATE id;
        private final String stds;

        public JvmValidationResult(String formattedText, STATE id, String stdouts) {
            this.id = id;
            this.formattedText = formattedText;
            this.stds = stdouts;
        }

        public static enum STATE {
            EMPTY,
            NOT_DIR,
            NOT_VALID_DIR,
            NOT_VALID_JDK,
            VALID_JDK;

        }
    }
}

