/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.utils;

import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class TimeZoneWrapper {
    private final TimeZone timeZone;
    private final long currentTimestamp;

    public TimeZoneWrapper(TimeZone timeZone, long currentTimestamp) {
        this.timeZone = timeZone;
        this.currentTimestamp = currentTimestamp;
    }

    private String getTimeZoneText() {
        int offset = this.timeZone.getOffset(this.currentTimestamp);
        long hours = TimeUnit.MILLISECONDS.toHours(offset);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(offset) - TimeUnit.HOURS.toMinutes(hours);
        minutes = Math.abs(minutes);
        if (hours >= 0L) {
            return String.format("%s (GMT+%d:%02d)", this.timeZone.getID(), hours, minutes);
        }
        return String.format("%s (GMT%d:%02d)", this.timeZone.getID(), hours, minutes);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeZoneWrapper other = (TimeZoneWrapper)obj;
        return this.timeZone == other.timeZone || this.timeZone != null && this.timeZone.equals(other.timeZone);
    }

    public String toString() {
        return this.getTimeZoneText();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }
}

