/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.opensearch.Version;
import org.opensearch.common.metrics.OperationMetrics;
import org.opensearch.common.metrics.OperationStats;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.pipeline.SystemGeneratedProcessorMetrics;
import reactor.util.annotation.NonNull;

public class SearchPipelineStats
implements Writeable,
ToXContentFragment {
    private final OperationStats totalRequestStats;
    private final OperationStats totalResponseStats;
    private final List<PerPipelineStats> perPipelineStats;
    private final Map<String, PipelineDetailStats> perPipelineProcessorStats;
    private FactoryDetailStats systemGeneratedFactoryStats;
    private PipelineDetailStats systemGeneratedProcessorStats;

    public SearchPipelineStats(OperationStats totalRequestStats, OperationStats totalResponseStats, List<PerPipelineStats> perPipelineStats, Map<String, PipelineDetailStats> perPipelineProcessorStats, FactoryDetailStats systemGeneratedFactoryStats, PipelineDetailStats systemGeneratedProcessorStats) {
        this.totalRequestStats = totalRequestStats;
        this.totalResponseStats = totalResponseStats;
        this.perPipelineStats = perPipelineStats;
        this.perPipelineProcessorStats = perPipelineProcessorStats;
        this.systemGeneratedFactoryStats = systemGeneratedFactoryStats;
        this.systemGeneratedProcessorStats = systemGeneratedProcessorStats;
    }

    public SearchPipelineStats(StreamInput in) throws IOException {
        this.totalRequestStats = new OperationStats(in);
        this.totalResponseStats = new OperationStats(in);
        int size = in.readVInt();
        ArrayList<PerPipelineStats> perPipelineStats = new ArrayList<PerPipelineStats>(size);
        TreeMap<String, PipelineDetailStats> pipelineDetailStatsMap = new TreeMap<String, PipelineDetailStats>();
        for (int i = 0; i < size; ++i) {
            PerPipelineStats perPipelineStat = new PerPipelineStats(in);
            perPipelineStats.add(perPipelineStat);
            pipelineDetailStatsMap.put(perPipelineStat.pipelineId, new PipelineDetailStats(in));
        }
        this.perPipelineStats = Collections.unmodifiableList(perPipelineStats);
        this.perPipelineProcessorStats = Collections.unmodifiableMap(pipelineDetailStatsMap);
        if (in.getVersion().onOrAfter(Version.V_3_3_0)) {
            this.systemGeneratedFactoryStats = new FactoryDetailStats(in);
            this.systemGeneratedProcessorStats = new PipelineDetailStats(in);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("search_pipeline");
        builder.startObject("total_request");
        this.totalRequestStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("total_response");
        this.totalResponseStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("pipelines");
        for (PerPipelineStats pipelineStat : this.perPipelineStats) {
            builder.startObject(pipelineStat.pipelineId);
            builder.startObject("request");
            pipelineStat.requestStats.toXContent(builder, params);
            builder.endObject();
            builder.startObject("response");
            pipelineStat.responseStats.toXContent(builder, params);
            builder.endObject();
            PipelineDetailStats pipelineDetailStats = this.perPipelineProcessorStats.get(pipelineStat.pipelineId);
            pipelineDetailStats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        if (this.systemGeneratedProcessorStats != null) {
            builder.startObject("system_generated_processors");
            this.systemGeneratedProcessorStats.toXContent(builder, params);
            builder.endObject();
        }
        if (this.systemGeneratedFactoryStats != null) {
            builder.startObject("system_generated_factories");
            this.systemGeneratedFactoryStats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.totalRequestStats.writeTo(out);
        this.totalResponseStats.writeTo(out);
        out.writeVInt(this.perPipelineStats.size());
        for (PerPipelineStats pipelineStat : this.perPipelineStats) {
            pipelineStat.writeTo(out);
            PipelineDetailStats pipelineDetailStats = this.perPipelineProcessorStats.get(pipelineStat.pipelineId);
            pipelineDetailStats.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_3_3_0)) {
            this.systemGeneratedFactoryStats.writeTo(out);
            this.systemGeneratedProcessorStats.writeTo(out);
        }
    }

    OperationStats getTotalRequestStats() {
        return this.totalRequestStats;
    }

    OperationStats getTotalResponseStats() {
        return this.totalResponseStats;
    }

    List<PerPipelineStats> getPipelineStats() {
        return this.perPipelineStats;
    }

    Map<String, PipelineDetailStats> getPerPipelineProcessorStats() {
        return this.perPipelineProcessorStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchPipelineStats stats = (SearchPipelineStats)o;
        return this.totalRequestStats.equals(stats.totalRequestStats) && this.totalResponseStats.equals(stats.totalResponseStats) && this.perPipelineStats.equals(stats.perPipelineStats) && this.perPipelineProcessorStats.equals(stats.perPipelineProcessorStats) && this.systemGeneratedFactoryStats.equals(stats.systemGeneratedFactoryStats) && this.systemGeneratedProcessorStats.equals(stats.systemGeneratedProcessorStats);
    }

    public int hashCode() {
        return Objects.hash(this.totalRequestStats, this.totalResponseStats, this.perPipelineStats, this.perPipelineProcessorStats, this.systemGeneratedFactoryStats, this.systemGeneratedProcessorStats);
    }

    static class FactoryDetailStats
    implements ToXContentFragment,
    Writeable {
        private final List<FactoryStats> requestProcessorFactoryStats;
        private final List<FactoryStats> responseProcessorFactoryStats;

        FactoryDetailStats(List<FactoryStats> requestProcessorFactoryStats, List<FactoryStats> responseProcessorFactoryStats) {
            this.requestProcessorFactoryStats = requestProcessorFactoryStats;
            this.responseProcessorFactoryStats = responseProcessorFactoryStats;
        }

        FactoryDetailStats(StreamInput in) throws IOException {
            int numRequestProcessorFactories = in.readVInt();
            this.requestProcessorFactoryStats = new ArrayList<FactoryStats>(numRequestProcessorFactories);
            for (int j = 0; j < numRequestProcessorFactories; ++j) {
                this.requestProcessorFactoryStats.add(new FactoryStats(in));
            }
            int numResponseProcessorFactories = in.readVInt();
            this.responseProcessorFactoryStats = new ArrayList<FactoryStats>(numResponseProcessorFactories);
            for (int j = 0; j < numResponseProcessorFactories; ++j) {
                this.responseProcessorFactoryStats.add(new FactoryStats(in));
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.requestProcessorFactoryStats.size());
            for (FactoryStats factoryStats : this.requestProcessorFactoryStats) {
                factoryStats.writeTo(out);
            }
            out.writeVInt(this.responseProcessorFactoryStats.size());
            for (FactoryStats factoryStats : this.responseProcessorFactoryStats) {
                factoryStats.writeTo(out);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.writeFactoryStatsArray(builder, params, "request_processor_factories", this.requestProcessorFactoryStats);
            this.writeFactoryStatsArray(builder, params, "response_processor_factories", this.responseProcessorFactoryStats);
            return builder;
        }

        private void writeFactoryStatsArray(XContentBuilder builder, ToXContent.Params params, String fieldName, List<FactoryStats> stats) throws IOException {
            builder.startArray(fieldName);
            for (FactoryStats factoryStats : stats) {
                builder.startObject();
                factoryStats.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FactoryDetailStats that = (FactoryDetailStats)o;
            return this.requestProcessorFactoryStats.equals(that.requestProcessorFactoryStats) && this.responseProcessorFactoryStats.equals(that.responseProcessorFactoryStats);
        }

        public int hashCode() {
            return Objects.hash(this.requestProcessorFactoryStats, this.responseProcessorFactoryStats);
        }
    }

    static class PipelineDetailStats
    implements ToXContentFragment,
    Writeable {
        private final List<ProcessorStats> requestProcessorStats;
        private final List<ProcessorStats> responseProcessorStats;

        public PipelineDetailStats(List<ProcessorStats> requestProcessorStats, List<ProcessorStats> responseProcessorStats) {
            this.requestProcessorStats = requestProcessorStats;
            this.responseProcessorStats = responseProcessorStats;
        }

        public PipelineDetailStats(StreamInput in) throws IOException {
            int numRequestProcessors = in.readVInt();
            this.requestProcessorStats = new ArrayList<ProcessorStats>(numRequestProcessors);
            for (int j = 0; j < numRequestProcessors; ++j) {
                this.requestProcessorStats.add(new ProcessorStats(in));
            }
            int numResponseProcessors = in.readVInt();
            this.responseProcessorStats = new ArrayList<ProcessorStats>(numResponseProcessors);
            for (int j = 0; j < numResponseProcessors; ++j) {
                this.responseProcessorStats.add(new ProcessorStats(in));
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.requestProcessorStats.size());
            for (ProcessorStats processorStats : this.requestProcessorStats) {
                processorStats.writeTo(out);
            }
            out.writeVInt(this.responseProcessorStats.size());
            for (ProcessorStats processorStats : this.responseProcessorStats) {
                processorStats.writeTo(out);
            }
        }

        public List<ProcessorStats> requestProcessorStats() {
            return this.requestProcessorStats;
        }

        public List<ProcessorStats> responseProcessorStats() {
            return this.responseProcessorStats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipelineDetailStats that = (PipelineDetailStats)o;
            return this.requestProcessorStats.equals(that.requestProcessorStats) && this.responseProcessorStats.equals(that.responseProcessorStats);
        }

        public int hashCode() {
            return Objects.hash(this.requestProcessorStats, this.responseProcessorStats);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.writeProcessorStatsArray(builder, params, "request_processors", this.requestProcessorStats);
            this.writeProcessorStatsArray(builder, params, "response_processors", this.responseProcessorStats);
            return builder;
        }

        private void writeProcessorStatsArray(XContentBuilder builder, ToXContent.Params params, String fieldName, List<ProcessorStats> stats) throws IOException {
            builder.startArray(fieldName);
            for (ProcessorStats processorStats : stats) {
                builder.startObject();
                processorStats.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    static class PerPipelineStats
    implements Writeable {
        private final String pipelineId;
        private final OperationStats requestStats;
        private final OperationStats responseStats;

        public PerPipelineStats(String pipelineId, OperationStats requestStats, OperationStats responseStats) {
            this.pipelineId = pipelineId;
            this.requestStats = requestStats;
            this.responseStats = responseStats;
        }

        public PerPipelineStats(StreamInput in) throws IOException {
            this.pipelineId = in.readString();
            this.requestStats = new OperationStats(in);
            this.responseStats = new OperationStats(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.pipelineId);
            this.requestStats.writeTo(out);
            this.responseStats.writeTo(out);
        }

        public String getPipelineId() {
            return this.pipelineId;
        }

        public OperationStats getRequestStats() {
            return this.requestStats;
        }

        public OperationStats getResponseStats() {
            return this.responseStats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerPipelineStats that = (PerPipelineStats)o;
            return this.pipelineId.equals(that.pipelineId) && this.requestStats.equals(that.requestStats) && this.responseStats.equals(that.responseStats);
        }

        public int hashCode() {
            return Objects.hash(this.pipelineId, this.requestStats, this.responseStats);
        }
    }

    static class FactoryStats
    implements ToXContentFragment,
    Writeable {
        private final String factoryType;
        private final OperationStats evaluationStats;
        private final OperationStats generationStats;

        FactoryStats(String factoryType, OperationStats evaluationStats, OperationStats generationStats) {
            this.factoryType = factoryType;
            this.evaluationStats = evaluationStats;
            this.generationStats = generationStats;
        }

        FactoryStats(StreamInput in) throws IOException {
            this.factoryType = in.readString();
            this.evaluationStats = new OperationStats(in);
            this.generationStats = new OperationStats(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.factoryType);
            this.evaluationStats.writeTo(out);
            this.generationStats.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.factoryType);
            builder.field("type", this.factoryType);
            builder.startObject("evaluation_stats");
            this.evaluationStats.toXContent(builder, params);
            builder.endObject();
            builder.startObject("generation_stats");
            this.generationStats.toXContent(builder, params);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FactoryStats that = (FactoryStats)o;
            return this.factoryType.equals(that.factoryType) && this.evaluationStats.equals(that.evaluationStats) && this.generationStats.equals(that.generationStats);
        }

        public int hashCode() {
            return Objects.hash(this.factoryType, this.evaluationStats, this.generationStats);
        }
    }

    static class ProcessorStats
    implements ToXContentFragment,
    Writeable {
        private final String processorName;
        private final String processorType;
        private final OperationStats stats;

        public ProcessorStats(String processorName, String processorType, OperationStats stats) {
            this.processorName = processorName;
            this.processorType = processorType;
            this.stats = stats;
        }

        public ProcessorStats(StreamInput in) throws IOException {
            this.processorName = in.readString();
            this.processorType = in.readString();
            this.stats = new OperationStats(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.processorName);
            out.writeString(this.processorType);
            this.stats.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessorStats that = (ProcessorStats)o;
            return this.processorName.equals(that.processorName) && this.processorType.equals(that.processorType) && this.stats.equals(that.stats);
        }

        public int hashCode() {
            return Objects.hash(this.processorName, this.processorType, this.stats);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.processorName);
            builder.field("type", this.processorType);
            builder.startObject("stats");
            this.stats.toXContent(builder, params);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        String getProcessorName() {
            return this.processorName;
        }

        String getProcessorType() {
            return this.processorType;
        }

        OperationStats getStats() {
            return this.stats;
        }
    }

    static class Builder {
        private OperationStats totalRequestStats;
        private OperationStats totalResponseStats;
        private final List<PerPipelineStats> perPipelineStats = new ArrayList<PerPipelineStats>();
        private final Map<String, List<ProcessorStats>> requestProcessorStatsPerPipeline = new HashMap<String, List<ProcessorStats>>();
        private final Map<String, List<ProcessorStats>> responseProcessorStatsPerPipeline = new HashMap<String, List<ProcessorStats>>();
        private FactoryDetailStats systemGeneratedFactoryStats = new FactoryDetailStats(Collections.emptyList(), Collections.emptyList());
        private PipelineDetailStats systemGeneratedProcessorStats = new PipelineDetailStats(Collections.emptyList(), Collections.emptyList());

        Builder() {
        }

        Builder withTotalStats(OperationMetrics totalRequestMetrics, OperationMetrics totalResponseMetrics) {
            this.totalRequestStats = totalRequestMetrics.createStats();
            this.totalResponseStats = totalResponseMetrics.createStats();
            return this;
        }

        Builder addPipelineStats(String pipelineId, OperationMetrics pipelineRequestMetrics, OperationMetrics pipelineResponseMetrics) {
            this.perPipelineStats.add(new PerPipelineStats(pipelineId, pipelineRequestMetrics.createStats(), pipelineResponseMetrics.createStats()));
            return this;
        }

        Builder addRequestProcessorStats(String pipelineId, String processorName, String processorType, OperationMetrics processorMetrics) {
            this.requestProcessorStatsPerPipeline.computeIfAbsent(pipelineId, k -> new ArrayList()).add(new ProcessorStats(processorName, processorType, processorMetrics.createStats()));
            return this;
        }

        Builder addResponseProcessorStats(String pipelineId, String processorName, String processorType, OperationMetrics processorMetrics) {
            this.responseProcessorStatsPerPipeline.computeIfAbsent(pipelineId, k -> new ArrayList()).add(new ProcessorStats(processorName, processorType, processorMetrics.createStats()));
            return this;
        }

        Builder withSystemGeneratedProcessorMetrics(@NonNull SystemGeneratedProcessorMetrics systemGeneratedProcessorMetrics) {
            this.systemGeneratedFactoryStats = systemGeneratedProcessorMetrics.getFactoryStats();
            this.systemGeneratedProcessorStats = systemGeneratedProcessorMetrics.getProcessorStats();
            return this;
        }

        SearchPipelineStats build() {
            TreeMap<String, PipelineDetailStats> pipelineDetailStatsMap = new TreeMap<String, PipelineDetailStats>();
            for (PerPipelineStats pipelineStat : this.perPipelineStats) {
                List requestProcessorStats = this.requestProcessorStatsPerPipeline.getOrDefault(pipelineStat.pipelineId, Collections.emptyList());
                List responseProcessorStats = this.responseProcessorStatsPerPipeline.getOrDefault(pipelineStat.pipelineId, Collections.emptyList());
                PipelineDetailStats pipelineDetailStats = new PipelineDetailStats(Collections.unmodifiableList(requestProcessorStats), Collections.unmodifiableList(responseProcessorStats));
                pipelineDetailStatsMap.put(pipelineStat.pipelineId, pipelineDetailStats);
            }
            return new SearchPipelineStats(this.totalRequestStats, this.totalResponseStats, Collections.unmodifiableList(this.perPipelineStats), Collections.unmodifiableMap(pipelineDetailStatsMap), this.systemGeneratedFactoryStats, this.systemGeneratedProcessorStats);
        }
    }
}

