/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration.gui;

import com.install4j.api.launcher.SplashScreen;
import com.install4j.runtime.installer.frontend.LookAndFeelHelper;
import com.install4j.runtime.launcher.integration.gui.AwtAndFxWindowChecker;
import com.install4j.runtime.launcher.integration.gui.SwtWindowChecker;

public abstract class WindowChecker
extends Thread {
    public static final String PROPNAME_SWT = "install4j.swt";
    public static final String PROPNAME_SPLASH_AUTO_HIDE = "install4j.splashAutoHide";
    private Runnable runnable;
    private boolean adjustLaf;

    public static void initSplashAutoHide() {
        if (Boolean.getBoolean(PROPNAME_SPLASH_AUTO_HIDE)) {
            WindowChecker.onFirstWindowShown(() -> {
                try {
                    SplashScreen.hide();
                }
                catch (SplashScreen.ConnectionException e) {
                    e.printStackTrace();
                }
            }, false);
        }
    }

    public static void onFirstWindowShown(Runnable runnable2, boolean adjustLaf) {
        if (Boolean.getBoolean(PROPNAME_SWT) && WindowChecker.isSwtPresent()) {
            new SwtWindowChecker(runnable2, adjustLaf).start();
        } else {
            new AwtAndFxWindowChecker(runnable2, adjustLaf).start();
        }
    }

    private static boolean isSwtPresent() {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected WindowChecker(Runnable runnable2, boolean adjustLaf) {
        super("install4j: window checker");
        this.runnable = runnable2;
        this.adjustLaf = adjustLaf;
        this.setDaemon(true);
    }

    protected void setAdjustLaf(boolean adjustLaf) {
        this.adjustLaf = adjustLaf;
    }

    @Override
    public void run() {
        try {
            WindowChecker.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean execute2 = false;
        while (!execute2) {
            try {
                WindowChecker.sleep(200L);
                execute2 = this.checkExecute();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.adjustLaf) {
            LookAndFeelHelper.setLookAndFeelUnconditional();
        }
        this.runnable.run();
    }

    protected abstract boolean checkExecute();
}

