/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.AppleMakernoteDirectory;

public class AppleMakernoteDescriptor
extends TagDescriptor<AppleMakernoteDirectory> {
    public AppleMakernoteDescriptor(@NotNull AppleMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 10: {
                return this.getHdrImageTypeDescription();
            }
            case 8: {
                return this.getAccelerationVectorDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getHdrImageTypeDescription() {
        return this.getIndexedDescription(10, 3, "HDR Image", "Original Image");
    }

    @Nullable
    public String getAccelerationVectorDescription() {
        Rational[] values = ((AppleMakernoteDirectory)this._directory).getRationalArray(8);
        if (values == null || values.length != 3) {
            return null;
        }
        return String.format("%.2fg %s, ", values[0].getAbsolute().doubleValue(), values[0].isPositive() ? "left" : "right") + String.format("%.2fg %s, ", values[1].getAbsolute().doubleValue(), values[1].isPositive() ? "down" : "up") + String.format("%.2fg %s", values[2].getAbsolute().doubleValue(), values[2].isPositive() ? "forward" : "backward");
    }
}

