/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import org.jetbrains.kotlin.fir.analysis.wasm.checkers.FirWasmJsCodeHelpersKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirScriptSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/expression/FirWasmJsCodeCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkers.wasm"})
@SourceDebugExtension(value={"SMAP\nFirWasmJsCodeCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWasmJsCodeCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/expression/FirWasmJsCodeCallChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,89:1\n31#2:90\n28#2:91\n*S KotlinDebug\n*F\n+ 1 FirWasmJsCodeCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/expression/FirWasmJsCodeCallChecker\n*L\n58#1:90\n61#1:91\n*E\n"})
public final class FirWasmJsCodeCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirWasmJsCodeCallChecker INSTANCE = new FirWasmJsCodeCallChecker();

    private FirWasmJsCodeCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol = firCallableSymbol;
        if (!Intrinsics.areEqual(symbol.getCallableId(), WebCommonStandardClassIds.Callables.Js)) {
            return;
        }
        List<FirBasedSymbol<?>> containingDeclarations = context2.getContainingDeclarations();
        FirBasedSymbol<?> firBasedSymbol = CollectionsKt.lastOrNull(containingDeclarations);
        if (firBasedSymbol == null) {
            return;
        }
        FirBasedSymbol<?> containingDeclaration = firBasedSymbol;
        FirBasedSymbol<?> containingDeclarationOfContainingDeclaration = CollectionsKt.getOrNull(containingDeclarations, containingDeclarations.size() - 2);
        boolean isContainingDeclarationTopLevel = containingDeclarationOfContainingDeclaration instanceof FirFileSymbol || containingDeclarationOfContainingDeclaration instanceof FirScriptSymbol;
        KtSourceElement source = expression2.getCalleeReference().getSource();
        if (!isContainingDeclarationTopLevel) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), null, 8, null);
            return;
        }
        FirBasedSymbol<?> firBasedSymbol2 = containingDeclaration;
        if (firBasedSymbol2 instanceof FirNamedFunctionSymbol) {
            if (!FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirNamedFunctionSymbol)containingDeclaration)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), null, 8, null);
            } else {
                FirCallableSymbol $this$isSuspend$iv = (FirCallableSymbol)containingDeclaration;
                boolean $i$f$isSuspend = false;
                if ($this$isSuspend$iv.getRawStatus().isSuspend()) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_UNSUPPORTED_FUNCTION_KIND(), (Object)"suspend function", null, 16, null);
                }
                FirCallableSymbol $this$isInline$iv = (FirCallableSymbol)containingDeclaration;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getRawStatus().isInline()) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_UNSUPPORTED_FUNCTION_KIND(), (Object)"inline function", null, 16, null);
                }
                if (FirDeclarationUtilKt.isExtension((FirCallableSymbol)containingDeclaration)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_UNSUPPORTED_FUNCTION_KIND(), (Object)"function with extension receiver", null, 16, null);
                }
                for (FirValueParameterSymbol parameter : ((FirNamedFunctionSymbol)containingDeclaration).getValueParameterSymbols()) {
                    String string = parameter.getName().getIdentifierOrNullIfSpecial();
                    if (string != null ? IdentifierPolicyKt.isValidES5Identifier(string) : false) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)parameter.getSource(), FirWasmErrors.INSTANCE.getJSCODE_INVALID_PARAMETER_NAME(), null, 8, null);
                }
            }
        } else if (firBasedSymbol2 instanceof FirPropertySymbol) {
            if (!FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirPropertySymbol)containingDeclaration)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), null, 8, null);
            }
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirWasmErrors.INSTANCE.getJSCODE_WRONG_CONTEXT(), null, 8, null);
        }
    }
}

