/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.LoadingCommittedChangeListPanel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogCommitDataCache;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryModel;
import com.intellij.vcs.log.ui.actions.history.FileHistoryOneCommitAction;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014JF\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n0\u000eH\u0014J(\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/ui/actions/history/ShowAllAffectedFromHistoryAction;", "Lcom/intellij/vcs/log/ui/actions/history/FileHistoryOneCommitAction;", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "<init>", "()V", "getCache", "Lcom/intellij/vcs/log/VcsLogCommitDataCache;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "loadData", "", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "onSuccess", "Lkotlin/Function1;", "", "onError", "", "performAction", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/vcs/log/history/FileHistoryModel;", "detail", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public final class ShowAllAffectedFromHistoryAction
extends FileHistoryOneCommitAction<VcsFullCommitDetails> {
    @Override
    @NotNull
    protected VcsLogCommitDataCache<VcsFullCommitDetails> getCache(@NotNull VcsLogData logData) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        CommitDetailsGetter commitDetailsGetter = logData.getCommitDetailsGetter();
        Intrinsics.checkNotNullExpressionValue((Object)commitDetailsGetter, (String)"getCommitDetailsGetter(...)");
        return commitDetailsGetter;
    }

    @Override
    protected void loadData(@NotNull VcsLogData logData, @NotNull VcsLogCommitSelection selection, @NotNull Function1<? super List<? extends VcsFullCommitDetails>, Unit> onSuccess, @NotNull Function1<? super Throwable, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        logData.getCommitDetailsGetter().loadCommitsData((List<Integer>)selection.getIds(), arg_0 -> ShowAllAffectedFromHistoryAction.loadData$lambda$1(arg_0 -> ShowAllAffectedFromHistoryAction.loadData$lambda$0(onSuccess, arg_0), arg_0), (Consumer<? super Throwable>)((Consumer<Throwable>)((Consumer)arg_0 -> ShowAllAffectedFromHistoryAction.loadData$lambda$3(arg_0 -> ShowAllAffectedFromHistoryAction.loadData$lambda$2(onError, arg_0), arg_0))), (ProgressIndicator)null);
    }

    @Override
    protected void performAction(@NotNull Project project, @NotNull FileHistoryModel model, @NotNull VcsFullCommitDetails detail2, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)detail2, (String)"detail");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FilePath file = model.getPathInCommit((Hash)detail2.getId());
        Object[] objectArray = new Object[]{((Hash)detail2.getId()).toShortString()};
        String string = VcsLogBundle.message("dialog.title.paths.affected.by.commit", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        LoadingCommittedChangeListPanel panel = new LoadingCommittedChangeListPanel(project);
        panel.loadChangesInBackground(() -> ShowAllAffectedFromHistoryAction.performAction$lambda$4(detail2, file));
        ChangeListViewerDialog.show((Project)project, (String)title, (LoadingCommittedChangeListPanel)panel);
    }

    private static final Unit loadData$lambda$0(Function1 $onSuccess, List details) {
        Intrinsics.checkNotNull((Object)details);
        $onSuccess.invoke((Object)details);
        return Unit.INSTANCE;
    }

    private static final void loadData$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit loadData$lambda$2(Function1 $onError, Throwable t) {
        Intrinsics.checkNotNull((Object)t);
        $onError.invoke((Object)t);
        return Unit.INSTANCE;
    }

    private static final void loadData$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final LoadingCommittedChangeListPanel.ChangelistData performAction$lambda$4(VcsFullCommitDetails $detail, FilePath $file) {
        CommittedChangeListForRevision committedChangeListForRevision = VcsLogUtil.createCommittedChangeList($detail);
        Intrinsics.checkNotNullExpressionValue((Object)committedChangeListForRevision, (String)"createCommittedChangeList(...)");
        CommittedChangeListForRevision committedChangeList = committedChangeListForRevision;
        return new LoadingCommittedChangeListPanel.ChangelistData((CommittedChangeList)committedChangeList, $file);
    }
}

